-- File generated with hex2prom.exe  DO NOT EDIT THIS FILE!
-- Copyright (C) 2017  Dr. Uwe Meyer-Baese.
-- ==================================================================
LIBRARY ieee;
USE ieee.STD_LOGIC_1164.ALL;
USE ieee.STD_LOGIC_arith.ALL;
USE ieee.STD_LOGIC_unsigned.ALL;
-- =====================================================
ENTITY rom4096x18 IS
PORT (clk   : IN STD_LOGIC;      -- System clock
      reset : IN STD_LOGIC;      -- Asynchronous reset
      pma   : IN STD_LOGIC_VECTOR(11 DOWNTO 0); -- Program memory address
      pmd   : OUT STD_LOGIC_VECTOR(17 DOWNTO 0)); -- Program memory data
END ENTITY rom4096x18;
-- =====================================================
ARCHITECTURE fpga OF rom4096x18 IS
-- Program ROM definition and values
TYPE MEMP IS ARRAY (0 TO 4095) OF STD_LOGIC_VECTOR(17 DOWNTO 0);
CONSTANT prom : MEMP := (
"001001000100000000", "100000000000001101", "001011001000000001", 
"001011001000000010", "001011001000000011", "101101001000000000", 
"100010000000000000", "101111000100000011", "100101000000000000", 
"101111000100000010", "010001000100000001", "100000000000000111", 
"100101000000000000", "101111000100000001", "010001000100000001", 
"100000000000001001", "100101000000000000", OTHERS => "100010000000000000");

BEGIN
-- The following process will be mapped to a BlockRAM for Zynq/Virtex/Spartan
-- devices (if addr > 4 bit!) and to Distributed RAM in all other cases

prog_rom: PROCESS (reset, clk)
BEGIN
  IF reset = '0' THEN               -- Asynchronous clear
    pmd <= (OTHERS => '0');     
  ELSIF rising_edge(clk) THEN
      pmd <= prom(CONV_INTEGER(pma)); -- Read from ROM
  END IF;
END PROCESS;

END ARCHITECTURE fpga;
